//Licensed to the Apache Software Foundation (ASF) under one
//or more contributor license agreements.  See the NOTICE file
//distributed with this work for additional information
//    regarding copyright ownership.  The ASF licenses this file
//to you under the Apache License, Version 2.0 (the
//"License"); you may not use this file except in compliance
//with the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing,
//software distributed under the License is distributed on an
//"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
//KIND, either express or implied.  See the License for the
//specific language governing permissions and limitations
//under the License.

import Foundation

func SafariIcon() -> String {
   return "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAACktJREFUeNqcVwlwlOUZfv5rsxeb3ewmuxs22dwJJhACSLgRJIwHWjodz9GJprGHF9QetEOVqtXWmU5breJRBoe2jtVqi0hbW1QwKPEAIUAoaAiEJLubkM3e9/7/3/f7EyxG26I7ebPH93/P897f+3G4wNf9Dzxkme7xdIoC387z/CyO4z61rqoqFEU5nJeVbcNDQ1s23bcxeiG43P9b/8Uvf11lLyrabjDomxrra1DuccFid3/uw9GgH2eGAug90YdUKn00OD6+9nv3rO9n+n0ZBYQtW7dtNhl137hkYStc5V5s23MKW3cPoOsDHxBL/weWoUzTY9nFpehY4UX7JZUInBnAnu73kEhmn+nsaL+dnpC/iALS1me3DVRVlLmXX7IYP/x9Lx55vhcoENHc4Eaj1wGrWQ+306g97B9JIhxPo3dgDD3H/UAmjw03NOLnNzfirT3voP/0oL/j1nYvPZq7EAWkLVuePb104dxSS0kZZm3YjbPhHNoW1cHrtEJVVMgUb1lWUFps0Db4zqYgCDwEyguO5zAwEsaufR+h2Crh8CMrEB0dxN7uA77OzlsrpioxVQHpt1u2nlk4v8WV05eg5e43UDljOpa1VFOCySSUaFqykT/pn6tYr20KnE1D4HnQH3hSgicleEFE14d9OHXch4OProSUHkX3+wcDt3V2lJ+vBH9+zB/f/NSTlGQuvYXI172JWa21aG2pRFLOI0EWM4nnFSgiUOoyYekMuybsM/uNrcVJyRjZFeUFzJ7lxcxFF6Fl/W7oLU6WwC7GwbimKsDdve47ddOMhq8vnNeM1k3dqG/yoKbSjVRORSoP7b2oUI/rl5djdYsbgigglJU1YZ9XzynFtSsqUeiwICyZUXWiBwvuWoJiUwr1M8sJcx8YNuNgXOe8L55zfUPDjJdnNjZgwx/7IAt61DRVIiXLmqvzsooFtTbUTzfjuXeGkcoqWiiMZlErhP1nYtjvozCYjeio16H6jtth7n4B37/sm9C5alHjyGDkbFTDvq21AYlU5mXaNpskq3lgxcpLHXqdNMNqd+CZvSNonluDLJFmKNZpknm1RcipHJ58YxBR8oRCwVY4HjK950UJqQIjIhYbrtv+DNqWzUPNe7vwJ0cl/Ks7kMllCUvRMBk242BcjPNcCIRVq9o6ystK8Zf9o/C4rYDRqJEzKbEaUOc2480TIdyyzAN3kRFpMjtNMba4LdCXF6LhzHHsuudS3LDjaeTkDHqUJAI/2Ij6ujpkczLhqBomw2YcjItxMm6mgM5kMt1otxXin8cicJc7kSH3ZmghRfvaZjmwtdsPlR7t6ovgmgUuzJ7hxAcRAYHBIDrXfRu/e+QWcNEQgswbuTw2t6zEu/pmtDVMozAqhAcNk2EzDsbFOBk3ywG9JEkzjIYC9EcFOErNVCMc9XYOOlqOZ1jmq6AzADtPRGFzmFFBubD31Ga0PrCVQpFDQGdAHESUyeIQJeR7C6+EvbAM8WSWMATkaD91CEhmM/qHBDAuxsm4mQIiO0jy2RxZKaE3wZIzryVfE3W6HUR6IiKDnT1pqoYn9o3iwN1mzFlWjeSTIYRNZsQ5BclcDnI6hnuXXAd/8WyMB1PYcVyBKkk4Pp7U+gRL/BLi0LhUrY+LTAGOfUnEEzDqJZSVmiBQ08lRTa9psiCYVVFok7RSqXHpwVM869QsxtZejsjjD0O580dI6HRUGRmc8HpRd/PlaL6oBWo6hapCEXYd9QRVgSSypBUgjIsa16QCnFYFdIxSsuRgMhaAIxfyTCQRZoMITuCoznlym0Bx5HFnjYB8PIygL4CxVUvg/8l3iTxEPgvjxZtvQ3ndTFDO0h5oexkGw2KYDJtxMC7G+UkfYLokUymYTS70nM2wDNBC8IfDMZglHnsHE1r7nVsiwTmdx2AojEg0RjFOIrJ4LtTOW3GkbxSvhUwQ+6wQcmPa/sUeE7pyKZwcz2ohoEBjsalA41I/1QnZ4ZKXUWQSYJNU8HTq6QokDCTymF9mBMdyVSfhpaUcRkIRIo8iEYshEQ4h0HsUr5d5cera63HTV1YTEbm7QIBIGK20l2EwLIbJsBkH48JECDQPqMlk8uNYMlVbbcnjJNVMhFwt0ANJireZslgggA3VMgzZGPxkeZpiGAr48M7ho/iwwIN9hoVYv6wVDYVAD4XnZFSBSaI+QYqkWPZLHPKUxW5ORXVBHsQFxsm4mQfyfr//VfajVxdFI52wMgsgxUuk2D1/MoVNF1vR4YoiGIkiNDqC17v24vZ/9GN86TVobf8WUNaAxw6N4+kjUXy11og8uXv9HBtePEnZL01gMUyGzTgYF+Nk3MwD6R2vbH+uwuu9p9oehMtYhemk6ZgiaPHpo47UKAeQi4Rw4IP38dShUex3tgKr5kP12hGjPqETFYhk4bFYHj1HY7iywohDNEMMpGVIOsp+WptOoXEZeDjTQZyMxMA4GTdTIDswcHoknkj2xyKhqgp9AKsLK/BsVIJI5/pyWw6Ovrfw2NtHEK2cj962m8ileij5vNb1UtmJs0EmbY2U9XfWmtATyWGXPwORcof6mVY9VxdmUZEJgDjAuBgn4xYmi0CIx+PHvJVVN3r1efA2D2z6AhyOpHHd+4/iVyMW7Gq8AWr9fHTWGDDbQsMHeekimwArWcgTwVqPAUtdBfizL4uDEfIIlS5HimV4EV8rVFAvpVA2dhAD/hG8sn17+/DwUB/r9ucGA8XnG042zWyu5EWpwSMlYHPXIKQz4oVsCVLNbTCYDIhSB9sXzOFfcQXTqDwXOSjRRI4sVtEVktFFazGZ+gZ5QiXvZanNzJnG4TIrhWD4bQwP+zE45Nvx8ksvbiPOcTaofqIA+/Ju975DCxYtuZaMMtrlEA2fVXC7SnAgqdK8p2ohYbOfTO8jNFQNkvt7Yio+SpIbhYk1jq2TpMnydiePK2wcivp3IzIawGhwPPizhx+8hY2RLP44fzSaHJuVPbvf/PvsuRev1auK0ZYKwFPqwfwiPQbzPAJkHfle63Bs+Cw2kvvpcyhPvwsTpZYht9eYRGz0CqgXkjAdex1hKtkz/sDY/ZvuvYo4BtkVYtLozw6lJGxQqLx30wOv2gqnFZU5HRBq5kGsaMA4bXkrBPSSxf1UHZ6JqRxD9L2qgKqFvi+3ATZKSPn0ccgf78fg6BhCkdj4g/ffx8hPkYydP5R+7lg+qYT3jrvW/dhV4rzSVeKAzW4H5ygD7/RCsJWAk/Cpi4lKkHJoFMrIANSxQYSCQQSIPDA68tcnfvPoT+mpgank//NiQkK2wNXYNLNpzZqrHzIZ9BVWqxVmOkxMeqOWaOe/ZBrhEukknQ8ZhMNhmvvSp3fu3LGx9+iRo2xyJwld6MXkkzGdhDnZTlJst9udl12x5qrS0tI2g15fqU657bF5IZVOn/L5fLte+9vOV4PBIKvzsyRBdtZ90avZ+evSpCImEgsJdXwYptwpzlVSiiQymWSJSeLcl72cfp5HdGyMmjzEpu5VtVFqoryy/83iqa9/CzAAd4d6nAeKxkIAAAAASUVORK5CYII="
}

func SettingsIcon() -> String {
return "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"
}

func AddressIcon() -> String {
return "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"
}

func NewsIcon() -> String {
return "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"
}

func HealthIcon() -> String {
return "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"
}

func MapsIcon() -> String {
return "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAIoUlEQVR42t1Xe1BU5xX/3Xv37sI+2BVdkF1AKw8BRaUxRHxg0pAoFbUxMzU61TSJU9ux/uOMiklsmpBqfMRYddq09ZG2dmIzmGgzVkMMteMziXF8IYFdHsq+kGVhYXfZ193bc++uRKi0nclkMtMzfJy9y3e/3+8753fO98HgWzbm/5pAeXm5Mi0tLbW2ttb1jRKoqqoaVVhYOJGsgHxBXl5eQUpKSgHP8xMuX7587REymhb7WgRKS0vZ/Pz87IL7bNy4cQUqlWqiQqFIZ8iikQiivgBiA0F5gFdA0Gv7DQbDGFoi/D8RqKioUNNO8qSdSDuShtFolHaTz3GcOibG0BPoRPeAAx4aAxEfStMXQhRFMDTQ2A7iAmlelAjopxUhOzs7z2azWUcksGLFill79ux5Wa1WS7vJZlmWC0eDcPvt6A7GgWRPozfogsgKMgj9AsfwWDPlbbAMJz0i0tACRohBoM9BVoRhcgEqKysX1dXVfTgigbKyssoLF87//Z9t78Hus6An5IQv6gHLsTKQPKSpMuZXn1lw0CvT8HTOBmiUBnlBKfSMkodIfw+Hw+BYDhurq6t37969bUQCY8aMyXW5XJZ3G16DM2gBp1AMAkumZNQYlZSBVFUG+bFQIR39vtHwBgxwDLDoGABclPLH01ksLUmR0xGLUQqiEQgUjcOHD/9p9erVz/4nDag7OztdN32ndV2hdhg1WUhNMiEaNspAnoAGNgLpIBDJe2IsWA0PNlkJSOH2h8FwDJSBEI4vSkSCCAQH+mUC1280fDZnTnnZgyrhHgH+7Nmzn6uzCqd+aBXgjCjgCLEIkYhYjZJCykEMRmUgtRBFVjKDzGSQBzI1NEax+O1NAdfDPA48LEAVcSEaoUqICeB4LRRJqV4SspFwIiMRYPfv3/9e4YJlT7/0BeUtLCKNxxAgs06ESS9CrxIgREMEEJJ9jAgp+CQcaUvDiYgam8f6kKO205IiooJA1cDBlFWErOzsCU6ns23EMly/fv3WTS+/Ut3i9GL8GB4qLgEUDUMgMGnBe5qQS47EBTEe0Rg9f+rOwu+COvxY2Y+56TZpEoVfQCgURlZOCebPm1/1SX39iREJLF68+LmjtbUHO1q/gFKlktXLMKwMpuDp2dUL0duPWJCEcNsBbkYJwqmqQUJ3QmZsvqPGE8ogns3tItJBkoeASDgEo6mIKuHFDfv27dsxIgFqbDNv3Lhx3nnnJoGL4DgFkpqo5i3tiNJGXT4FnJpMuHVmdGrNMJtVKDdbBqMiUIWsvMSjSBXF5mn9ECk1DEudkHyS2kCV8O6hn69d+/yIBJKSkoye7m5Xr/s2GxMGZALXe3LwwVU1pmQB/bTxVI0sevAUfWdvDC9MayAQNl5GOiPWnhGxbHIy5pJwqJkhVl8HdsYsiMlqeDyenr8eObKp5vWa3xOO+KBWrGpsvNViVPeb0XsOSoUHV/wLsPviDDxaAGgp2gaNnFoEqKszgh9PfqdNXkH6LhLjkazPhJZKUwKXaIV+uhLcgh+AW7hE1olUkvX1n/x52TNLn/P5fMJwAtzx48fqK2aK5VxfDagXQVDko/rMIRRnqdDooChRZVy5DRKpiOrH2sAjECcUGIDemINktZbSx0KgLxs6uuAPxc+f7NF6ZKbqKHoxmcTevXtee3FT9SvDCTDbt2/bv+YnFc+z7lUkPAZSdAcwDUctG3GpIw/hKDA9+y6W52wDE0yDX7eACiEGX5DDWHMOpY1FHzWjy60OzJyYjVHaZOoFIhrtXXB0ezG7cByVbQwDwVCodHpJQTvZkNNw1apVG/f+eusbMduTUFIzZ8UER06EqM4krwMTsZLwiElURMBfAXusCilpE6HR6ogwg4+vWVH53YkyGfnMoPKVwm9ze+Hw9GHKuLFyFF6vefUXb+7cUTOEQHn5nKc+rqt73914hDogAaqMssrZSA+UoQaoxY+g0FKNs4nXaHctrcUYXbJPBnT19JM+ohhNemlra4W310tpIUFSOZfNnIXT15oxd9IEORWnTp48ufyZHy4YQsCUkVHU0mJt6HJZSETURrl4Lxg0UYC2/y9Qa+shcvFXLbZM6Mb/QQZk9UaYKN8GEqLdbselixcxv7ISt241yAT+QdGZPiEDVosFPr/vs8p5T5QNIUC71bqcjrtCuDdZiPjlUmRZFkOMwqn2HYM66W90RlB+W1OQXnxcDr+ju490IiCFuqjDYSdxBkjMCqnEMXVqCU5fbcKjxblyBD46daruR8uXVg6/EfHnz529ljvBVBgKeOSXpQjEm028dO8VsMp/GTocwm1PDzjz+9CmjJXn1V35Et9/uGiwQSU4o7O3D+0uDx7KzZSFuWVLzdbdu958aTgB9uDBA8cWVc1b6Pc6iACfiMB94KI42H7ZqBeM5yisPeORN/0FOdfuPh+uttoxe1IONElKeW6ryw0rVcL3puXLr4fDociM0oem222268MJMNXVG3duWL9undfd+hUBUfoRZdB7Awkv9fsvm6zInTQHesMoIsEgGIniWqsNIfLSHNNoA/JMxvhFhcZbu3bu2/7GlnWEF/m3S+mSJU+tfufggbc7bQ3UC+I3IzHRxViOJ10QKYWSPA3yPB3F0rF76dPPxfzC4qheb+DvhV/SgdlsRpyvvAV8cLT2xNo1P1tJFxbP8EYkW/HkyY+dO3umvtfjIEAFRUECUhGQSr6E0j1PoP7hbG62tDc1Nbc20YdmMqvV2qTVpWherfnVL6uqFj1OkWPv3u1EWlq6vK7b3eXZtXPHb/74zsG3iIznQWeBbBqNxtzeZu0I0UFOi3YQSDut39LUbJGAmtra2i2RSMQLqUlSu6dBXQlCQiLSeikZJtPkWbPnzDWZzKYwLURnzK2LF87XE3lH4h2MSIBMaTabHnE6XTYKk4+e6RyU/6mQgGL3FcJ/My4xxATBr/ef0Tdl3zqBfwGMOwRjn9LEQgAAAABJRU5ErkJggg=="
}

func CalendarIcon() -> String {
return "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"
}

func PhotosIcon() -> String {
return "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"
}

func DefaultAppIcon() -> String {
return "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"
}
